/*********************************
 *					             *
 * ļ: 03 ջͶ\04 Maze *
 * 					             *
 * ļ: Maze.c                *
 * 				                 *
 *   : 3.3                   *
 *                               *
 *********************************/

#ifndef MAZE_C
#define MAZE_C

#include "Maze.h"							//**03 ջͶ**//

/*TTTT[
U 㷨3.3U 
^TTTT*/
Status MazePath(MazeType maze[][N], PosType start, PosType end)
{
	SqStack S;
	SElemType_Sq nodeInf;					//nodeInf洢ǰͨϢ 
	PosType curPos;							//ǰλ 
	int curStep;							//ǰͨ 
	
	InitStack_Sq(&S);
	curPos = start;							//趨ǰλΪ"λ" 
	curStep = 1;
	
	do
	{
		if(Pass(curPos, maze))				//ǰλÿͨδʵͨ 
		{
			FootPrint(curPos, maze);		//㼣
			ShowMaze(maze); 

			SetSElemType(&nodeInf, curStep, curPos, East);	//ͨϢ
			Push_Sq(&S, nodeInf); 			//· 

			if(EqualPosType(curPos, end))	//յ
			{
				printf("\nѰ·ɹ\n\n");
				return TRUE;	
			}
			
			curPos = NextPos(curPos, East);	//һλǵǰλõĶ 
			curStep++;						//̽һ 
		}
		else								//ǰλòͨ 
		{
			if(!StackEmpty_Sq(S))
			{
				Pop_Sq(&S, &nodeInf);		//޸Ľָ
				 
				while(nodeInf.di==North && !StackEmpty_Sq(S))	//ͨ4򶼱 
				{
					MarkPrint(nodeInf.seat, maze);				//²ͨıǣ˻һ 
					ShowMaze(maze);

					Pop_Sq(&S, &nodeInf);
				}

				if(nodeInf.di<North)
				{
					maze[nodeInf.seat.x][nodeInf.seat.y] = ++nodeInf.di;//ı̽Թ±	
					ShowMaze(maze);

					Push_Sq(&S, nodeInf);

					curPos = NextPos(nodeInf.seat, nodeInf.di);
				}
			}
		}		
	}while(!StackEmpty_Sq(S));	
	
	printf("\nѰ·ʧܣ\n\n");
	
	return FALSE;	
}

void InitMaze(MazeType maze[][N], PosType *start, PosType *end) 
{												//ԹģΪNN 
	int i, j, tmp;
		
	srand((unsigned)time(NULL));				//ϵͳʱ 
	
	for(i=0; i<N; i++)
	{
		for(j=0; j<N; j++)
		{
			if(i==0 || j==0 || i==N-1 || j==N-1)
				maze[i][j] = Wall;				//Թǽ
			else
			{
				tmp = rand()%X;					//Թ 		
				if(!tmp)
					maze[i][j] = Obstacle;		//1/Xĸϰ 
				else
					maze[i][j] = Way;			//ط· 
			}
		}	
	}
	
	(*start).x = 1;								//Թ
	(*start).y = 0;
	(*end).x = N-2;								//Թ 
	(*end).y = N-1;	
	
	maze[1][0] = maze[N-2][N-1] = Way;			//ںͳ 
	maze[1][1] = maze[N-2][N-2] = Way;			//Ϊ߳ɹʣڴͳڴٽĽһֱΪͨ· 
}

void PaintMaze(MazeType maze[][N])
{
	int i, j;
	
	for(i=0; i<N; i++)
		for(j=0; j<N; j++)
		{
			if(maze[i][j]==Wall)				//ǽ 
				printf("~");
			else if(maze[i][j]==Obstacle)		//ڲϰ 
				printf("");
			else if(maze[i][j]==East)			//̽
				printf("");
			else if(maze[i][j]==South)			//̽
				printf("");
			else if(maze[i][j]==West)			//̽
				printf("");
			else if(maze[i][j]==North)			//̽
				printf("");
			else if(maze[i][j]==DeadLock)		//ʹҲͨĽ 
				printf("");
			else								//δʹ· 
				printf("  ");

			if(j!=0 && j%(N-1)==0)				//ÿN㻻 
				printf("\n");
		}
}

void ShowMaze(MazeType maze[][N])	//൱ˢ² 
{
	Wait(SleepTime);				//ͣ 
	system("cls");					//Ļ 
	PaintMaze(maze);				//ĻϻԹ 
} 

Status EqualPosType(PosType seat1, PosType seat2)
{
	if(seat1.x==seat2.x && seat1.y==seat2.y)
		return TRUE;	//ͨȷ1 
	else
		return ERROR;
}

Status Pass(PosType seat, MazeType maze[][N])		 
{
	int x = seat.x;
	int y = seat.y;
	
	if(!IsCross(seat) && maze[x][y]==Way)	//㲻Խ
		return TRUE;
	else
		return ERROR;
}

void FootPrint(PosType seat, MazeType maze[][N])	//ν㼣һηʷ 
{	
	maze[seat.x][seat.y] = East; 					//ʼ̽ 
} 

void SetSElemType (SElemType_Sq *e, int ord, PosType seat, int di)
{
	(*e).ord = ord;
	(*e).seat = seat;
	(*e).di = di;
}

PosType NextPos(PosType seat, int di)
{	
	PosType tmp = seat;

	switch(di)
	{
		case East:  tmp.y++;			// 
			break;	
		case South: tmp.x++;			//
			break;
		case West:  tmp.y--;			// 
			break;
		case North: tmp.x--;			//
			break;
	}
	
	return tmp;
}

Status IsCross(PosType seat)
{
	int x = seat.x;
	int y = seat.y;
	
	if(x<0 || y<0 || x>N-1 || y>N-1)
		return TRUE;					//Խ 
	else
		return FALSE; 
}

void MarkPrint(PosType seat, MazeType maze[][N])
{
	int x = seat.x;
	int y = seat.y;
	
	maze[x][y] = DeadLock;			    //²ͨı 
}

#endif
